/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.client.render.entity.animation.AnimationContextTracker;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.ai.goal.MaulerBurrowDownGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.MaulerLookAroundGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.MaulerLookAtEntityGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.MaulerMeeleAttackGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.MaulerWanderAroundFarGoal;
import com.faboslav.friendsandfoes.init.ModSounds;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class MaulerEntity
extends PathfinderMob
implements NeutralMob,
AnimatedEntity {
    private static final int HEALTH = 20;
    private static final float ANGERED_MOVEMENT_SPEED = 0.5f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float ATTACK_DAMAGE = 8.0f;
    private static final int MAXIMUM_STORED_EXPERIENCE_POINTS = 1395;
    public static final int MIN_TICKS_UNTIL_NEXT_BURROWING = 6000;
    public static final int MAX_TICKS_UNTIL_NEXT_BURROWING = 9000;
    private static final Predicate<Entity> BABY_ZOMBIE_PREDICATE = entity -> entity instanceof Zombie && ((Zombie)entity).m_6162_();
    private static final Predicate<Entity> SMALL_SLIME_PREDICATE = entity -> entity instanceof Slime && ((Slime)entity).m_33632_() == 1;
    private static final String TYPE_NBT_NAME = "Type";
    private static final String STORED_EXPERIENCE_POINTS_NBT_NAME = "StoredExperiencePoints";
    private static final String IS_BURROWED_DOWN_NBT_NAME = "IsBurrowedDown";
    private static final String TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME = "TicksUntilNextBurrowingDown";
    private static final String BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME = "BurrowingDownAnimationProgress";
    private static final String BURROWED_DOWN_TICKS_NBT_NAME = "BurrowedDownTicks";
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STORED_EXPERIENCE_POINTS = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_MOVING = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BURROWED_DOWN = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_NEXT_BURROWING_DOWN = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> BURROWING_DOWN_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @OnlyIn(value=Dist.CLIENT)
    private AnimationContextTracker animationTickTracker;
    @Nullable
    private UUID angryAt;
    public MaulerBurrowDownGoal burrowDownGoal;

    public MaulerEntity(EntityType<? extends MaulerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.DESERT.name());
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(STORED_EXPERIENCE_POINTS, (Object)0);
        this.f_19804_.m_135372_(IS_MOVING, (Object)false);
        this.f_19804_.m_135372_(IS_BURROWED_DOWN, (Object)false);
        this.f_19804_.m_135372_(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)RandomGenerator.generateInt(6000, 9000));
        this.f_19804_.m_135372_(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
        nbt.m_128359_(TYPE_NBT_NAME, this.getMaulerType().getName());
        nbt.m_128405_(STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints());
        nbt.m_128379_(IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown());
        nbt.m_128405_(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown());
        nbt.m_128350_(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress());
        if (this.isBurrowedDown() && this.burrowDownGoal.getBurrowedDownTicks() > 0) {
            nbt.m_128405_(BURROWED_DOWN_TICKS_NBT_NAME, this.burrowDownGoal.getBurrowedDownTicks());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_183503_(), nbt);
        this.setType(Type.fromName(nbt.m_128461_(TYPE_NBT_NAME)));
        this.setStoredExperiencePoints(nbt.m_128451_(STORED_EXPERIENCE_POINTS_NBT_NAME));
        this.setBurrowedDown(nbt.m_128471_(IS_BURROWED_DOWN_NBT_NAME));
        this.setTicksUntilNextBurrowingDown(nbt.m_128451_(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME));
        this.setBurrowingDownAnimationProgress(nbt.m_128457_(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME));
        if (this.isBurrowedDown() && nbt.m_128441_(BURROWED_DOWN_TICKS_NBT_NAME)) {
            this.burrowDownGoal.setBurrowedDownTicks(nbt.m_128451_(BURROWED_DOWN_TICKS_NBT_NAME));
            this.m_20331_(true);
            this.m_6842_(true);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        ResourceKey biomeKey = world.m_204166_(this.m_142538_()).m_203543_().orElse(Biomes.f_48157_);
        Type type = Type.getTypeByBiome((ResourceKey<Biome>)biomeKey);
        this.m_21530_();
        this.setType(type);
        this.setSize(false);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.m_8077_();
    }

    public static boolean canSpawn(EntityType<MaulerEntity> maulerEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        BlockState blockState = serverWorldAccess.m_8055_(blockPos.m_7495_());
        boolean isRelatedBlock = blockState.m_60713_(Blocks.f_49992_) || blockState.m_60713_(Blocks.f_49993_) || blockState.m_60713_(Blocks.f_50493_) || blockState.m_60713_(Blocks.f_50546_) || blockState.m_60713_(Blocks.f_50440_);
        return isRelatedBlock;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MaulerMeeleAttackGoal(this, 0.5, false));
        this.f_21345_.m_25352_(3, (Goal)new MaulerWanderAroundFarGoal(this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new MaulerLookAtEntityGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new MaulerLookAroundGoal(this));
        this.burrowDownGoal = new MaulerBurrowDownGoal(this);
        this.f_21345_.m_25352_(6, (Goal)this.burrowDownGoal);
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 10, true, true, BABY_ZOMBIE_PREDICATE));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, 10, true, true, SMALL_SLIME_PREDICATE));
    }

    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableMauler) {
            this.m_146870_();
        }
        super.m_8119_();
        if (this.m_183503_().m_5776_()) {
            return;
        }
        if (this.getTicksUntilNextBurrowingDown() > 0) {
            this.setTicksUntilNextBurrowingDown(this.getTicksUntilNextBurrowingDown() - 1);
        }
        this.updateBurrowingDownAnimation();
    }

    public void m_8107_() {
        if (!this.m_183503_().m_5776_() && this.getBurrowingDownAnimationProgress() > 0.0f) {
            this.m_21573_().m_26517_(0.0);
            this.m_21573_().m_26573_();
        }
        super.m_8107_();
        if (this.m_183503_().m_5776_()) {
            return;
        }
        this.m_21666_((ServerLevel)this.m_183503_(), true);
        this.setMoving(this.m_21573_().m_26572_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_183503_().m_5776_()) {
            this.burrowDownGoal.m_8041_();
        }
        return super.m_6469_(source, amount);
    }

    public float m_6113_() {
        return this.m_21660_() ? 0.5f : 0.3f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        boolean interactionResult = false;
        if (!this.m_21660_() && (itemStack.m_41793_() || itemInHand == Items.f_42690_)) {
            interactionResult = this.tryToInteractWithEnhancedItem(itemStack);
        } else if (!this.m_21660_() && itemInHand == Items.f_42590_) {
            interactionResult = this.tryToInteractWithGlassBottle(player, itemStack);
        }
        if (interactionResult) {
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private boolean tryToInteractWithEnhancedItem(ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints >= 1395) {
            return false;
        }
        int experiencePoints = this.getExperiencePoints(itemStack);
        int recalculatedExperiencePoints = storedExperiencePoints + experiencePoints;
        if (recalculatedExperiencePoints > 1395) {
            recalculatedExperiencePoints = 1395;
        }
        this.setStoredExperiencePoints(recalculatedExperiencePoints);
        itemStack.m_41774_(1);
        this.m_5496_((SoundEvent)ModSounds.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        this.spawnParticles((ParticleOptions)ParticleTypes.f_123809_, 7);
        return true;
    }

    private boolean tryToInteractWithGlassBottle(Player player, ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints < 7) {
            return false;
        }
        int experienceBottleCount = storedExperiencePoints / 7;
        int glassBottlesCount = itemStack.m_41613_();
        if (experienceBottleCount > glassBottlesCount) {
            experienceBottleCount = glassBottlesCount;
        }
        itemStack.m_41774_(experienceBottleCount);
        ItemStack experienceBottleItemStack = new ItemStack((ItemLike)Items.f_42612_, experienceBottleCount);
        player.m_36356_(experienceBottleItemStack);
        this.setStoredExperiencePoints(storedExperiencePoints - experienceBottleCount * 7);
        this.m_5496_(SoundEvents.f_11771_, 1.0f, 1.0f);
        return true;
    }

    public boolean m_5843_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0);
    }

    public boolean m_6094_() {
        return !this.isBurrowedDown() && super.m_6094_();
    }

    public void m_7324_(Entity entity) {
        if (this.isBurrowedDown()) {
            return;
        }
        super.m_7324_(entity);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_MAULER_GROWL.get();
    }

    public void m_8032_() {
        if (this.m_21660_() && this.isMoving() || this.isBurrowedDown()) {
            return;
        }
        this.m_5496_(this.m_7515_(), 0.5f, RandomGenerator.generateFloat(0.75f, 0.85f));
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.ENTITY_MAULER_HURT.get();
    }

    public void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(this.m_7975_(source), 0.5f, RandomGenerator.generateFloat(0.85f, 0.95f));
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENTITY_MAULER_DEATH.get();
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        super.m_7355_(pos, state);
        if (this.m_21660_() && this.isMoving() && this.m_20096_() && this.m_20184_().m_7098_() <= 1.0E-4) {
            this.m_5496_((SoundEvent)ModSounds.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        }
    }

    public boolean m_7327_(Entity target) {
        if (this.isBurrowedDown()) {
            return false;
        }
        return target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int angerTime) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)angerTime);
    }

    public void m_6825_() {
        int angerTime = RandomGenerator.generateInt(400, 1000);
        this.m_7870_(angerTime);
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6925_(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public Type getMaulerType() {
        return Type.fromName((String)this.f_19804_.m_135370_(TYPE));
    }

    private void setType(Type type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.name);
    }

    public int getStoredExperiencePoints() {
        return (Integer)this.f_19804_.m_135370_(STORED_EXPERIENCE_POINTS);
    }

    public void setStoredExperiencePoints(int storedExperiencePoints) {
        this.f_19804_.m_135381_(STORED_EXPERIENCE_POINTS, (Object)storedExperiencePoints);
        this.f_21364_ = storedExperiencePoints;
        this.setSize(false);
    }

    public void setSize(boolean heal) {
        float size = this.getSize();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)((int)(20.0f * size)));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(8.0f * (size / 2.0f)));
        this.m_6210_();
        this.m_142242_();
        if (heal) {
            this.m_21153_(this.m_21233_());
        }
    }

    public float getSize() {
        return 1.0f + (float)this.getStoredExperiencePoints() / 1395.0f * 0.5f;
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(IS_MOVING);
    }

    public void setMoving(boolean isMoving) {
        this.f_19804_.m_135381_(IS_MOVING, (Object)isMoving);
    }

    public boolean isBurrowedDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_BURROWED_DOWN);
    }

    public void setBurrowedDown(boolean isBurrowedDown) {
        this.f_19804_.m_135381_(IS_BURROWED_DOWN, (Object)isBurrowedDown);
    }

    public int getTicksUntilNextBurrowingDown() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_NEXT_BURROWING_DOWN);
    }

    public void setTicksUntilNextBurrowingDown(int ticksUntilNextBurrowingDown) {
        this.f_19804_.m_135381_(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)ticksUntilNextBurrowingDown);
    }

    public float getBurrowingDownAnimationProgress() {
        return ((Float)this.f_19804_.m_135370_(BURROWING_DOWN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setBurrowingDownAnimationProgress(float burrowingDownAnimationProgress) {
        this.f_19804_.m_135381_(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(burrowingDownAnimationProgress));
    }

    private void updateBurrowingDownAnimation() {
        if (this.isBurrowedDown()) {
            this.setBurrowingDownAnimationProgress(Math.min(1.0f, this.getBurrowingDownAnimationProgress() + 0.04f));
        } else {
            this.setBurrowingDownAnimationProgress(Math.max(0.0f, this.getBurrowingDownAnimationProgress() - 0.04f));
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getSize());
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    private int getExperiencePoints(ItemStack stack) {
        int experiencePoints = 0;
        Map mappedEnchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry enchantmentItem : mappedEnchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)enchantmentItem.getKey();
            Integer enchantmentExperiencePoints = (Integer)enchantmentItem.getValue();
            if (((Enchantment)enchantmentItem.getKey()).m_6589_()) continue;
            experiencePoints += enchantment.m_6183_(enchantmentExperiencePoints.intValue());
        }
        return experiencePoints;
    }

    public void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level world = this.m_183503_();
        if (world.m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)world).m_8767_(particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, this.m_21187_().nextGaussian() * 0.02, this.m_21187_().nextGaussian() * 0.02, this.m_21187_().nextGaussian() * 0.02, 1.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationTickTracker == null) {
            this.animationTickTracker = new AnimationContextTracker();
        }
        return this.animationTickTracker;
    }

    public static enum Type {
        BADLANDS("badlands"),
        DESERT("desert"),
        SAVANNA("savanna");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Type fromName(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return SAVANNA;
        }

        public static Type getTypeByBiome(ResourceKey<Biome> biome) {
            if (biome == Biomes.f_48203_) {
                return DESERT;
            }
            if (biome == Biomes.f_48159_ || biome == Biomes.f_48194_ || biome == Biomes.f_186753_) {
                return BADLANDS;
            }
            return SAVANNA;
        }
    }
}

